#ifndef MYWINDOW2_GUEST_FUNCTION_H_INCLUDED
#define MYWINDOW1_GUEST_FUNCTION_H_INCLUDED
#include<gtkmm.h>
#include "functions.h"
#include "guest_user.h"
b_search::b_search(){
    set_position(Gtk::WIN_POS_CENTER);
    set_default_size(300, 100);
    set_title("BOOK SEARCH");

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    grid->set_column_spacing(10);
    vbox->add(*grid);

    Gtk::Label *lbl1 = Gtk::manage(new Gtk::Label("ENTER BOOK NAME"));
    grid->attach(*lbl1, 0, 0, 1, 1);

    Gtk::Label *lbl2 = Gtk::manage(new Gtk::Label(""));
    grid->attach(*lbl2, 0, 1, 1, 1);

    Gtk::Entry *txtfld1 = Gtk::manage(new Gtk::Entry());
    grid->attach(*txtfld1, 1, 0, 2, 1);

    Gtk::Entry *txtfld2 = Gtk::manage(new Gtk::Entry());


    Gtk::Button *blogin = Gtk::manage(new Gtk::Button("SEARCH"));
    blogin->signal_clicked().connect(sigc::bind<Gtk::Entry*>(sigc::mem_fun(*this, &b_search::on_button_click), txtfld1));
    grid->attach(*blogin, 2, 3, 1, 1);

    vbox->show_all();
}
b_search::~b_search(){

}
void b_search::on_button_click(Gtk::Entry *txtfld1){

    char b_name[30];
    copy_ustring(b_name,txtfld1->get_text());
    if(book_search(b_name)){
        bsearch *popup=new bsearch;
        popup->popup= new SEARCH(b_name);
        popup->popup->show();
        hide();
    }
    else{
        Gtk::MessageDialog dlg("Book not found", false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
        dlg.set_title("ERROR");
        dlg.run();
    }
}

a_account::a_account(){
    set_position(Gtk::WIN_POS_CENTER);
    set_default_size(500, 300);
    set_title("APPLY FOR ACCOUNT");

    set_default_size(300, 100);
    set_title("APPLY FOR ACCOUNT");

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    grid->set_column_spacing(10);
    vbox->add(*grid);

    Gtk::Label *lbl1 = Gtk::manage(new Gtk::Label("ENTER YOUR NAME"));
    grid->attach(*lbl1, 0, 0, 1, 1);

    Gtk::Entry *txtfld1 = Gtk::manage(new Gtk::Entry());
    grid->attach(*txtfld1, 1, 0, 2, 1);

    Gtk::Button *blogin = Gtk::manage(new Gtk::Button("APPLY"));
    blogin->signal_clicked().connect(sigc::bind<Gtk::Entry*>(sigc::mem_fun(*this, &a_account::on_button_click), txtfld1));
    grid->attach(*blogin, 2, 3, 1, 1);

    vbox->show_all();

}
a_account::~a_account(){
}

void a_account::on_button_click(Gtk::Entry *txtfld1){

        char m_name[30];
        copy_ustring(m_name,txtfld1->get_text());
        guest_apply_acc(m_name);
        Gtk::MessageDialog dlg("Success", false, Gtk::MESSAGE_INFO, Gtk::BUTTONS_OK, true);
        dlg.set_title("Success");
        dlg.run();
        hide();
}

void mywindow2::on_popup_close(apply_account *popup)
{
    delete popup->popup;
    delete popup;
    set_opacity(1);
}

v_rar::v_rar(){
    set_position(Gtk::WIN_POS_CENTER);
    set_default_size(500, 200);
    set_title("RULES AND REGULATIONS");


    //VIRTUAL BOX

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    //ADDING A GRID TO THE VBOX

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    grid->set_column_spacing(10);
    vbox->add(*grid);

    //A LABEL AT THE TOP

    Gtk::Label *heading1 = Gtk::manage(new Gtk::Label(""));
    heading1->set_hexpand(true);
    grid->attach(*heading1, 0, 0, 1, 1);

     Gtk::Label *heading2 = Gtk::manage(new Gtk::Label("RULES AND REGULATIONS"));
    heading2->set_hexpand(true);
    grid->attach(*heading2, 1, 0, 1, 1);

     Gtk::Label *heading3 = Gtk::manage(new Gtk::Label(""));
    heading3->set_hexpand(true);
    grid->attach(*heading3, 2, 0, 1, 1);

    Gtk::Label *heading4 = Gtk::manage(new Gtk::Label("1. Members can isue only one book at a time\n2. The books should be handled carefully. Any mishandling if spotted will directly cause loss of membership and fine.\n3. The users must bring a valid ID card and the user should never forget user ID and Pasword.\n4. Under no circumstances should any book be taken out of the library without checking it out.\n     However in case of any problem the user should approach the admin for any action to be taken.\n5. Guest users are not allowed to check out any book. However they are welcome to read in the library.\n6.Checking out and Deposition of books will be handled by the librarian and the administrator will address customer issues and feedbacks."));
    heading4->set_hexpand(true);
    grid->attach(*heading4, 1, 2, 1, 1);

    vbox->show_all();
}
v_rar::~v_rar(){
}
#endif
